package com.ejie.ab18a.utilidades;

import com.ejie.ab18a.log.Ab18aLog;


/**
 * The Class Ab18aException.
 * 
 * @author XXXX
 */
public class Ab18aException extends Exception {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 1L;

	/** The nombre_clase. */
	private String nombre_clase = "Ab18aException";

	/** The excepcion. */
	private Exception excepcion = null;

	/** The clase. */
	private String clase = null;

	/** The metodo. */
	private String metodo = null;

	/**
	 * Gets the clase.
	 * 
	 * @return the clase
	 */
	public String getClase() {
		return this.clase;
	}

	/**
	 * Gets the metodo.
	 * 
	 * @return the metodo
	 */
	public String getMetodo() {
		return this.metodo;
	}

	/**
	 * Gets the mensaje.
	 * 
	 * @return the mensaje
	 */
	public String getMensaje() {
		return this.excepcion.getMessage();
	}

	/**
	 * Instantiates a new Ab18a exception.
	 * 
	 * @param clase
	 *            the clase
	 * @param metodo
	 *            the metodo
	 * @param excepcion
	 *            the excepcion
	 */
	public Ab18aException(String clase, String metodo, Exception excepcion) {
		String nombre_metodo = "Ab18aException";
		Ab18aLog.error(this.nombre_clase, nombre_metodo,
				excepcion.getMessage(), 1);
		this.excepcion = excepcion;
		this.clase = clase;
		this.metodo = metodo;
	}

	/**
	 * Instantiates a new Ab18a exception.
	 * 
	 * @param clase
	 *            the clase
	 * @param metodo
	 *            the metodo
	 * @param error
	 *            the error
	 */
	public Ab18aException(String clase, String metodo, String error) {
		String nombre_metodo = "Ab18aException";
		Ab18aLog.error(this.nombre_clase, nombre_metodo, error, 1);
		this.clase = clase;
		this.metodo = metodo;
	}

}
